<?php
include 'user.php';
session_start();
include 'constants.php';
include 'portal_admin.php';

try{
  $portal = new PortalAdmin("localhost", "php", "test", "testphp");
}
catch(Exception $e){
  //echo 'Problem z baz danych. ' . $e->getMessage();
  exit('Panel administracyjny jest niedostpny.');
}

//Sprawdzenie czy jest parametr action
if (isset($_GET['action'])) {
  $action = $_GET['action'];
}
else{
  $action = 'showMainAdmin';
}

//Odczytanie komunikatu, jeli zosta przekazany
$komunikat_adm = $portal->getAdminMessage();

//Wykonanie procedury logowania lub wylogowania
switch($action){
  case 'login':
    if(!$portal->zalogowany_adm)
    switch($portal->login()){
      case LOGIN_OK:
        $portal->setAdminMessage("Zalogowanie prawidowe");
        break;
      case LOGIN_FAILED:
        $portal->setAdminMessage("Nieprawidowa nazwa lub haso!");
        break;
      case NO_ADMIN_RIGHTS:
        $portal->setAdminMessage("Brak uprawnie administracyjnych!");
        $portal->logout();
        break;
      case SERVER_ERROR:
      default:
        $portal->setAdminMessage("Bd serwera!");
        $portal->logout();
    }
    header('Location:index.php');
    exit();
  case 'logout':
    $portal->logout();
    header('Location:index.php');
    exit();
}

//Ustalenie akcji dla niezalogowanego uytkownika
if(!$portal->zalogowany_adm){
  $action = 'showLoginForm';
}
include 'templates/mainTemplate.php';
?>